#ifndef usb_R6_1H
#define usb_R6_1H

#define searchMaxDevice 10
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef struct _HIDD_ATTRIBUTES {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;
//---------------------------------------------------------
void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
bool (__stdcall *HidD_GetAttributes)(IN HANDLE HidDeviceObject,
                                    OUT PHIDD_ATTRIBUTES Attributes);
//---------------------------------------------------------
class TUSBDevice {
   private:
     string pathUSBDevice;
     DWORD memberIndex;
     HIDD_ATTRIBUTES hiddAttributes;
     PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData;
     DWORD numberOfBytesRead;
     DWORD result;
     GUID classGuid;
     HMODULE hHidLib;
     DWORD deviceInterfaceDetailDataSize;
     HDEVINFO deviceInfoSet;
     SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
     USHORT usVid;
     const char *chVid;
   public:
     TUSBDevice();
     ~TUSBDevice();
     void setUshortVid(USHORT vid);
     void displayError(const char* msg);
     bool synchReadUSBReport(HANDLE hidDevObject, void *inputReportBuffer,
                             ULONG inputReportBufferLength);
     HANDLE synchOpenUSBDevice();
     string getUSBDevicePath(UINT);
};
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//---------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
#endif

